<?php

/*
 * this class should be used to work with the administrative side of wordpress
 */

class dalt_Admin
{

    protected static $instance = null;
    private $shared = null;

    private $screen_id_tables = null;
    private $screen_id_import = null;
    private $screen_id_export = null;
	private $screen_id_help = null;
    private $screen_id_options = null;

    private function __construct()
    {

        //assign an instance of the plugin info
        $this->shared = dalt_Shared::get_instance();

        //Load admin stylesheets and JavaScript
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_styles'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_scripts'));

        //Add the admin menu
        add_action('admin_menu', array($this, 'me_add_admin_menu'));

        //Load the options API registrations and callbacks
        add_action('admin_init', array($this, 'op_register_options'));

        //Create tinymce plugin
        add_action('init', array($this, 'create_tinymce_plugin'));

        //this hook is triggered during the creation of a new blog
        add_action('wpmu_new_blog', array($this, 'new_blog_create_options_and_tables'), 10, 6);

        //this hook is triggered during the deletion of a blog
        add_action('delete_blog', array($this, 'delete_blog_delete_options_and_tables'), 10, 1);

        //Export XML controller
        add_action('init', array($this, 'export_xml_controller'));

	    //Require and instantiate the class used to register the menu options
	    require_once( $this->shared->get( 'dir' ) . 'admin/inc/class-dalt-menu-options.php' );
	    $this->menu_options = new Dalt_Menu_Options( $this->shared );

    }

    /*
     * return an instance of this class
     */
    public static function get_instance()
    {

        if (null == self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;

    }

    public function enqueue_admin_styles()
    {

        $screen = get_current_screen();

        //menu tables
        if ($screen->id == $this->screen_id_tables) {

	        //jQuery UI Dialog
	        wp_enqueue_style($this->shared->get('slug') . '-jquery-ui-dialog',
		        $this->shared->get('url') . 'admin/assets/css/jquery-ui-dialog.css', array(),
		        $this->shared->get('ver'));
	        wp_enqueue_style($this->shared->get('slug') . '-jquery-ui-dialog-custom',
		        $this->shared->get('url') . 'admin/assets/css/jquery-ui-dialog-custom.css', array(),
		        $this->shared->get('ver'));

            wp_enqueue_style($this->shared->get('slug') . '-framework-menu', $this->shared->get('url') . 'admin/assets/css/framework/menu.css', array(), $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-menu-tables', $this->shared->get('url') . 'admin/assets/css/menu-tables.css', array(), $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-jquery-ui-tooltip', $this->shared->get('url') . 'admin/assets/css/jquery-ui-tooltip.css', array(), $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-handsontable-full', $this->shared->get('url') . 'admin/assets/inc/handsontable/handsontable.full.min.css', array(), $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.css', array(), $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-chosen-custom', $this->shared->get('url') . 'admin/assets/css/chosen-custom.css', array(), $this->shared->get('ver'));
            wp_enqueue_style('wp-color-picker');

        }

        //menu options
        if ($screen->id == $this->screen_id_options) {
            wp_enqueue_style($this->shared->get('slug') . '-framework-options', $this->shared->get('url') . 'admin/assets/css/framework/options.css', array(), $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-jquery-ui-tooltip', $this->shared->get('url') . 'admin/assets/css/jquery-ui-tooltip.css', array(), $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.css', array(), $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-chosen-custom', $this->shared->get('url') . 'admin/assets/css/chosen-custom.css', array(), $this->shared->get('ver'));
        }

        $args = array(
            'show_ui' => true
        );
        $post_types_with_ui = get_post_types($args);
        unset($post_types_with_ui['attachment']);

        if (in_array($screen->id, $post_types_with_ui) and current_user_can(get_option( $this->shared->get('slug') . "_tables_menu_capability"))) {

            /*
             * This enables the use of custom icons from Dashicons without using a .png image.
             *
             * For details: https://www.gavick.com/blog/wordpress-tinymce-custom-buttons#tc-section-4
             */
            wp_enqueue_style($this->shared->get('slug') . '-enable-dashicons-in-tinymce', $this->shared->get('url') . 'admin/assets/css/enable-dashicons-in-tinymce.css', array(), $this->shared->get('ver'));

            //Load Chosen CSS
            wp_enqueue_style( $this->shared->get( 'slug' ) . '-chosen', $this->shared->get( 'url' ) . 'admin/assets/inc/chosen/chosen-min.css', array(), $this->shared->get( 'ver' ) );

            //Load the CSS used in the modal window opened when the TinyMCE League Table button is clicked
            wp_enqueue_style( $this->shared->get( 'slug' ) . '-tinymce-modal-window', $this->shared->get( 'url' ) . 'admin/assets/css/tinymce-leaguetable.css', array(), $this->shared->get( 'ver' ) );

        }

    }

    /*
     * enqueue admin-specific javascript
     */
    public function enqueue_admin_scripts()
    {

        $screen = get_current_screen();

        //menu tables
        if ($screen->id == $this->screen_id_tables) {

            wp_enqueue_script('jquery-ui-tooltip');
            wp_enqueue_script($this->shared->get('slug') . '-jquery-ui-tooltip-init', $this->shared->get('url') . 'admin/assets/js/jquery-ui-tooltip-init.js', array('jquery'), $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-handsontable-full', $this->shared->get('url') . 'admin/assets/inc/handsontable/handsontable.full.min.js', array('jquery'), $this->shared->get('ver'));
	        wp_enqueue_script($this->shared->get('slug') . '-tables-menu-utility', $this->shared->get('url') . 'admin/assets/js/tables/utility.js', array('jquery', 'jquery-ui-dialog'), $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-tables-menu-context-menu', $this->shared->get('url') . 'admin/assets/js/tables/context-menu.js', array('jquery', 'jquery-ui-dialog', 'dalt-tables-menu-utility'), $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-init', $this->shared->get('url') . 'admin/assets/js/tables/init.js', array('jquery', 'jquery-ui-dialog', 'dalt-tables-menu-utility'), $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.js', array('jquery'), $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-wp-color-picker-init', $this->shared->get('url') . 'admin/assets/js/wp-color-picker-init.js', array('jquery', 'wp-color-picker'), false, true);
            wp_enqueue_media();
            wp_enqueue_script($this->shared->get('slug') . '-media-uploader', $this->shared->get('url') . 'admin/assets/js/media-uploader.js', array('jquery'), $this->shared->get('ver'));

            //pass the objectL10n object to this javascript file
            wp_localize_script($this->shared->get('slug') . '-tables-menu-utility', 'objectL10n', array(
                'column' => strip_tags(__("Column", 'dalt')),
                'name' => strip_tags(__('Name', 'dalt')),
                'description' => strip_tags(__('Description', 'dalt')),
                'caption' => strip_tags(__('Caption', 'dalt')),
                'rows' => strip_tags(__('Rows', 'dalt')),
                'columns' => strip_tags(__('Columns', 'dalt')),
                'position_label' => strip_tags(__('Position Label', 'dalt')),
                'table_width_value' => strip_tags(__('Table Width Value', 'dalt')),
                'table_minimum_width' => strip_tags(__('Table Minimum Width', 'dalt')),
                'column_width_value' => strip_tags(__('Column Width Value', 'dalt')),
                'container_width' => strip_tags(__('Container Width', 'dalt')),
                'container_height' => strip_tags(__('Container Height', 'dalt')),
                'table_margin_top' => strip_tags(__('Table Margin Top', 'dalt')),
                'table_margin_bottom' => strip_tags(__('Table Margin Bottom', 'dalt')),
                'header_font_size' => strip_tags(__('Header Font Size', 'dalt')),
                'header_font_family' => strip_tags(__('Header Font Family', 'dalt')),
                'header_background_color' => strip_tags(__('Header Background Color', 'dalt')),
                'header_font_color' => strip_tags(__('Header Font Color', 'dalt')),
                'header_link_color' => strip_tags(__('Header Link Color', 'dalt')),
                'header_border_color' => strip_tags(__('Header Border Color', 'dalt')),
                'body_font_size' => strip_tags(__('Body Font Size', 'dalt')),
                'body_font_family' => strip_tags(__('Body Font Family', 'dalt')),
                'even_rows_background_color' => strip_tags(__('Even Rows Background Color', 'dalt')),
                'odd_rows_background_color' => strip_tags(__('Odd Rows Background Color', 'dalt')),
                'even_rows_font_color' => strip_tags(__('Even Rows Font Color', 'dalt')),
                'odd_rows_font_color' => strip_tags(__('Odd Rows Font Color', 'dalt')),
                'even_rows_link_color' => strip_tags(__('Even Rows Link Color', 'dalt')),
                'odd_rows_link_color' => strip_tags(__('Odd Rows Link Color', 'dalt')),
                'rows_border_color' => strip_tags(__('Rows Border Color', 'dalt')),
                'caption_font_size' => strip_tags(__('Caption Font Size', 'dalt')),
                'caption_font_family' => strip_tags(__('Caption Font Family', 'dalt')),
                'caption_font_color' => strip_tags(__('Caption Font Color', 'dalt')),
                'autocolors_affected_rows_1' => strip_tags(__('Affected Rows (Style 1)', 'dalt')),
                'autocolors_rows_background_color_1' => strip_tags(__('Rows Background Color (Style 1)', 'dalt')),
                'autocolors_rows_font_color_1' => strip_tags(__('Rows Font Color (Style 1)', 'dalt')),
                'autocolors_affected_rows_2' => strip_tags(__('Affected Rows (Style 2)', 'dalt')),
                'autocolors_rows_background_color_2' => strip_tags(__('Rows Background Color (Style 2)', 'dalt')),
                'autocolors_rows_font_color_2' => strip_tags(__('Rows Font Color (Style 2)', 'dalt')),
                'autocolors_affected_rows_3' => strip_tags(__('Affected Rows (Style 3)', 'dalt')),
                'autocolors_rows_background_color_3' => strip_tags(__('Rows Background Color (Style 3)', 'dalt')),
                'autocolors_rows_font_color_3' => strip_tags(__('Rows Font Color (Style 3)', 'dalt')),
                'autocolors_affected_rows_4' => strip_tags(__('Affected Rows (Style 4)', 'dalt')),
                'autocolors_rows_background_color_4' => strip_tags(__('Rows Background Color (Style 4)', 'dalt')),
                'autocolors_rows_font_color_4' => strip_tags(__('Rows Font Color (Style 4)', 'dalt')),
                'autocolors_affected_rows_5' => strip_tags(__('Affected Rows (Style 5)', 'dalt')),
                'autocolors_rows_background_color_5' => strip_tags(__('Rows Background Color (Style 5)', 'dalt')),
                'autocolors_rows_font_color_5' => strip_tags(__('Rows Font Color (Style 5)', 'dalt')),
                'autocolors_affected_columns_1' => strip_tags(__('Affected Columns (Style 1)', 'dalt')),
                'autocolors_columns_background_color_1' => strip_tags(__('Columns Background Color (Style 1)', 'dalt')),
                'autocolors_columns_font_color_1' => strip_tags(__('Columns Font Color (Style 1)', 'dalt')),
                'autocolors_affected_columns_2' => strip_tags(__('Affected Columns (Style 2)', 'dalt')),
                'autocolors_columns_background_color_2' => strip_tags(__('Columns Background Color (Style 2)', 'dalt')),
                'autocolors_columns_font_color_2' => strip_tags(__('Columns Font Color (Style 2)', 'dalt')),
                'autocolors_affected_columns_3' => strip_tags(__('Affected Columns (Style 3)', 'dalt', 'dalt')),
                'autocolors_columns_background_color_3' => strip_tags(__('Columns Background Color (Style 3)', 'dalt')),
                'autocolors_columns_font_color_3' => strip_tags(__('Columns Font Color (Style 3)', 'dalt')),
                'autocolors_affected_columns_4' => strip_tags(__('Affected Columns (Style 4)', 'dalt')),
                'autocolors_columns_background_color_4' => strip_tags(__('Columns Background Color (Style 4)', 'dalt')),
                'autocolors_columns_font_color_4' => strip_tags(__('Columns Font Color (Style 4)', 'dalt')),
                'autocolors_affected_columns_5' => strip_tags(__('Affected Columns (Style 5)', 'dalt')),
                'autocolors_columns_background_color_5' => strip_tags(__('Columns Background Color (Style 5)', 'dalt')),
                'autocolors_columns_font_color_5' => strip_tags(__('Columns Font Color (Style 5)', 'dalt')),
                'autoalignment_affected_rows_left' => strip_tags(__('Affected Rows (Left)', 'dalt')),
                'autoalignment_affected_rows_center' => strip_tags(__('Affected Rows (Center)', 'dalt')),
                'autoalignment_affected_rows_right' => strip_tags(__('Affected Rows (Right)', 'dalt')),
                'autoalignment_affected_columns_left' => strip_tags(__('Affected Columns (Left)', 'dalt')),
                'autoalignment_affected_columns_center' => strip_tags(__('Affected Columns (Center)', 'dalt')),
                'autoalignment_affected_columns_right' => strip_tags(__('Affected Columns (Right)', 'dalt')),
                'tablet_breakpoint' => strip_tags(__('Tablet Breakpoint', 'dalt')),
                'hide_tablet_list' => strip_tags(__('Tablet Hide List', 'dalt')),
                'tablet_header_font_size' => strip_tags(__('Tablet Header Font Size', 'dalt')),
                'tablet_body_font_size' => strip_tags(__('Tablet Body Font Size', 'dalt')),
                'tablet_caption_font_size' => strip_tags(__('Tablet Caption Font Size', 'dalt')),
                'phone_breakpoint' => strip_tags(__('Phone Breakpoint', 'dalt')),
                'hide_phone_list' => strip_tags(__('Phone Hide List', 'dalt')),
                'phone_header_font_size' => strip_tags(__('Phone Header Font Size', 'dalt')),
                'phone_body_font_size' => strip_tags(__('Phone Body Font Size', 'dalt')),
                'phone_caption_font_size' => strip_tags(__('Phone Caption Font Size', 'dalt')),
                'formula_average_decimals' => strip_tags(__('Formula Average Decimals', 'dalt')),
                'text_color' => strip_tags(__('Text Color', 'dalt')),
                'background_color' => strip_tags(__('Background Color', 'dalt')),
                'link' => strip_tags(__('Link', 'dalt')),
                'link_color' => strip_tags(__('Link Color', 'dalt')),
                'image_left' => strip_tags(__('Image Left', 'dalt')),
                'image_left_link' => strip_tags(__('Image Left Link', 'dalt')),
                'image_right_link' => strip_tags(__('Image Right Link', 'dalt')),
                'html_content' => strip_tags(__('HTML Content', 'dalt')),
                'formula_data' => strip_tags(__('Formula Data', 'dalt')),
                'row_slots' => strip_tags(__('Row Slots', 'dalt')),
                'column_slots' => strip_tags(__('Column Slots', 'dalt')),
                'update_cell_properties' => strip_tags(__('Update Cell Properties', 'dalt')),
                'add_cell_properties' => strip_tags(__('Add Cell Properties', 'dalt')),
                'cell_properties_added_message' => strip_tags(__('The cell properties have been successfully added.', 'dalt')),
                'cell_properties_updated_message' => strip_tags(__('The cell properties have been successfully updated.', 'dalt')),
                'cell_properties_reset_message' => strip_tags(__('The cell properties have been successfully deleted.', 'dalt')),
                'cell_properties_error_partial_message' => strip_tags(__('Please enter valid values in the following fields:', 'dalt')),
                'table_success' => strip_tags(__('The table has been successfully updated.', 'dalt')),
                'table_error_partial_message' => strip_tags(__('Please enter valid values in the following fields:', 'dalt')),
                'insert_row_above' => strip_tags(__('Insert Row Above', 'dalt')),
                'insert_row_below' => strip_tags(__('Insert Row Below', 'dalt')),
                'insert_column_left' => strip_tags(__('Insert Column Left', 'dalt')),
                'insert_column_right' => strip_tags(__('Insert Column Right', 'dalt')),
                'remove_row' => strip_tags(__('Remove Row', 'dalt')),
                'remove_column' => strip_tags(__('Remove Column', 'dalt')),
                'copy_data' => strip_tags(__('Copy Data', 'dalt')),
                'cut_data' => strip_tags(__('Cut Data', 'dalt')),
                'paste_data' => strip_tags(__('Paste Data', 'dalt')),
                'copy_to_spreadsheet_clipboard' => strip_tags(__('Copy to Spreadsheet Clipboard', 'dalt')),
                'paste_spreadsheet_clipboard_cell_data' => strip_tags(__('Paste Spreadsheet Clipboard Cell Data', 'dalt')),
                'paste_spreadsheet_clipboard_cell_properties' => strip_tags(__('Paste Spreadsheet Clipboard Cell Properties', 'dalt')),
                'paste_spreadsheet_clipboard_cell_data_and_cell_properties' => strip_tags(__('Paste Spreadsheet Clipboard Cell Data and Cell Properties', 'dalt')),
                'copy_cell_properties' => strip_tags(__('Copy Cell Properties', 'dalt')),
                'cut_cell_properties' => strip_tags(__('Cut Cell Properties', 'dalt')),
                'paste_cell_properties' => strip_tags(__('Paste Cell Properties', 'dalt')),
                'reset_data' => strip_tags(__('Reset Data', 'dalt')),
                'reset_cell_properties' => strip_tags(__('Reset Cell Properties', 'dalt')),
                'reset_data_and_cell_properties' => strip_tags(__('Reset Data and Cell Properties', 'dalt')),
                'delete' => strip_tags(__('Delete', 'dalt')),
                'cancel' => strip_tags(__('Cancel', 'dalt')),
            ));

	        $this->shared->add_global_javascript_parameters('-tables-menu-utility');

        }


        //menu options
        if ($screen->id == $this->screen_id_options) {
            wp_enqueue_script('jquery-ui-tooltip');
            wp_enqueue_script($this->shared->get('slug') . '-jquery-ui-tooltip-init', $this->shared->get('url') . 'admin/assets/js/jquery-ui-tooltip-init.js', array('jquery'), $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.js', array('jquery'), $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-jquery-ui-chosen-init', $this->shared->get('url') . 'admin/assets/js/chosen-init.js', array('jquery'), $this->shared->get('ver'));
        }

        //Enqueue scripts in all the post types of the post editor
        $args = array(
            'show_ui' => true
        );
        $post_types_with_ui = get_post_types($args);
        unset($post_types_with_ui['attachment']);

        if ( in_array( $screen->id, $post_types_with_ui ) and current_user_can(get_option( $this->shared->get('slug') . "_tables_menu_capability")) ) {

            //Load the Chosen JS
            wp_enqueue_script( $this->shared->get('slug') . '-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.js', 'jquery', $this->shared->get('ver') );

	        //Store the JavaScript parameters in the window.DALT_PARAMETERS object
	        $this->shared->add_global_javascript_parameters('-chosen');

        }

    }

    /*
     * plugin activation
     */
    public function ac_activate($networkwide)
    {

        /*
         * create options and tables for all the sites in the network
         */
        if (function_exists('is_multisite') and is_multisite()) {

            /*
             * if this is a "Network Activation" create the options and tables
             * for each blog
             */
            if ($networkwide) {

                //get the current blog id
                global $wpdb;
                $current_blog = $wpdb->blogid;

                //create an array with all the blog ids
                $blogids = $wpdb->get_col("SELECT blog_id FROM $wpdb->blogs");

                //iterate through all the blogs
                foreach ($blogids as $blog_id) {

                    //switch to the iterated blog
                    switch_to_blog($blog_id);

                    //create options and tables for the iterated blog
                    $this->ac_initialize_options();
                    $this->ac_create_database_tables();

                }

                //switch to the current blog
                switch_to_blog($current_blog);

            } else {

                /*
                 * if this is not a "Network Activation" create options and
                 * tables only for the current blog
                 */
                $this->ac_initialize_options();
                $this->ac_create_database_tables();

            }

        } else {

            /*
             * if this is not a multisite installation create options and
             * tables only for the current blog
             */
            $this->ac_initialize_options();
            $this->ac_create_database_tables();

        }

    }

    //create the options and tables for the newly created blog
    public function new_blog_create_options_and_tables($blog_id, $user_id, $domain, $path, $site_id, $meta)
    {

        global $wpdb;

        /*
         * if the plugin is "Network Active" create the options and tables for
         * this new blog
         */
        if (is_plugin_active_for_network('league-table/init.php')) {

            //get the id of the current blog
            $current_blog = $wpdb->blogid;

            //switch to the blog that is being activated
            switch_to_blog($blog_id);

            //create options and database tables for the new blog
            $this->ac_initialize_options();
            $this->ac_create_database_tables();

            //switch to the current blog
            switch_to_blog($current_blog);

        }

    }

    //delete options and tables for the deleted blog
    public function delete_blog_delete_options_and_tables($blog_id)
    {

        global $wpdb;

        //get the id of the current blog
        $current_blog = $wpdb->blogid;

        //switch to the blog that is being activated
        switch_to_blog($blog_id);

        //create options and database tables for the new blog
        $this->un_delete_options();
        $this->un_delete_database_tables();

        //switch to the current blog
        switch_to_blog($current_blog);

    }

    /*
     * initialize plugin options
     */
    private function ac_initialize_options()
    {

	    foreach ( $this->shared->get( 'options' ) as $key => $value ) {
		    add_option( $key, $value );
	    }

    }

    /*
     * create the plugin database tables
     */
    private function ac_create_database_tables()
    {

        //check database version and create the database
        if (intval(get_option($this->shared->get('slug') . '_database_version'), 10) < 3) {

            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

            //create *prefix*_table
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
            $sql = "CREATE TABLE $table_name (
                  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
                  temporary TINYINT(1) UNSIGNED DEFAULT 0,
                  name VARCHAR(255) DEFAULT 'Table Name',
                  description VARCHAR(255) DEFAULT 'Table Description',
                  caption TEXT DEFAULT '',
                  `rows` INT UNSIGNED DEFAULT 10,
                  columns INT UNSIGNED DEFAULT 10,
                  show_position TINYINT(1) UNSIGNED DEFAULT 0,
                  position_side VARCHAR(5) DEFAULT 'left',
                  order_by_1 INT UNSIGNED DEFAULT 1,
                  order_desc_asc_1 TINYINT(1) UNSIGNED DEFAULT 0,
                  order_data_type_1 VARCHAR(10) DEFAULT 'auto',
                  order_date_format_1 VARCHAR(8) DEFAULT 'ddmmyyyy',
                  order_by_2 INT UNSIGNED DEFAULT 1,
                  order_desc_asc_2 TINYINT(1) UNSIGNED DEFAULT 0,
                  order_data_type_2 VARCHAR(10) DEFAULT 'auto',
                  order_date_format_2 VARCHAR(8) DEFAULT 'ddmmyyyy',
                  order_by_3 INT UNSIGNED DEFAULT 1,
                  order_desc_asc_3 TINYINT(1) UNSIGNED DEFAULT 0,
                  order_data_type_3 VARCHAR(10) DEFAULT 'auto',
                  order_date_format_3 VARCHAR(8) DEFAULT 'ddmmyyyy',
                  order_by_4 INT UNSIGNED DEFAULT 1,
                  order_desc_asc_4 TINYINT(1) UNSIGNED DEFAULT 0,
                  order_data_type_4 VARCHAR(10) DEFAULT 'auto',
                  order_date_format_4 VARCHAR(8) DEFAULT 'ddmmyyyy',
                  order_by_5 INT UNSIGNED DEFAULT 1,
                  order_desc_asc_5 TINYINT(1) UNSIGNED DEFAULT 0,
                  order_data_type_5 VARCHAR(10) DEFAULT 'auto',
                  order_date_format_5 VARCHAR(8) DEFAULT 'ddmmyyyy',
                  table_layout TINYINT(1) UNSIGNED DEFAULT 0,
                  table_width INT UNSIGNED DEFAULT 0,
                  table_width_value INT UNSIGNED DEFAULT 400,
                  table_minimum_width INT UNSIGNED DEFAULT 0,
                  column_width TINYINT(1) UNSIGNED DEFAULT 0,
                  column_width_value VARCHAR(2000) DEFAULT '100',
                  table_margin_top INT UNSIGNED DEFAULT 20,
                  table_margin_bottom INT UNSIGNED DEFAULT 20,
                  enable_container TINYINT(1) UNSIGNED DEFAULT 0,
                  container_width INT UNSIGNED DEFAULT 400,
                  container_height INT UNSIGNED DEFAULT 400,
                  header_background_color VARCHAR(7) DEFAULT '#C3512F',
                  header_font_color VARCHAR(7) DEFAULT '#FFFFFF',
                  header_link_color VARCHAR(7) DEFAULT '#FFFFFF',
                  even_rows_background_color VARCHAR(7) DEFAULT '#FFFFFF',
                  even_rows_font_color VARCHAR(7) DEFAULT '#666666',
                  even_rows_link_color VARCHAR(7) DEFAULT '#C3512F',
                  odd_rows_background_color VARCHAR(7) DEFAULT '#FCFCFC',
                  odd_rows_font_color VARCHAR(7) DEFAULT '#666666',
                  odd_rows_link_color VARCHAR(7) DEFAULT '#C3512F',
                  header_border_color VARCHAR(7) DEFAULT '#B34A2A',
                  header_position_alignment VARCHAR(6) DEFAULT 'center',
                  rows_border_color VARCHAR(7) DEFAULT '#E1E1E1',
                  phone_breakpoint INT UNSIGNED DEFAULT 479,
                  tablet_breakpoint INT UNSIGNED DEFAULT 989,
                  position_label VARCHAR(255) DEFAULT '#',
                  number_format TINYINT(1) UNSIGNED DEFAULT 0,
                  enable_sorting TINYINT(1) UNSIGNED DEFAULT 0,
                  enable_manual_sorting TINYINT(1) UNSIGNED DEFAULT 0,
                  show_header TINYINT(1) UNSIGNED DEFAULT 1,
                  sticky_header TINYINT(1) UNSIGNED DEFAULT 0,
                  header_font_size INT UNSIGNED DEFAULT 11,
                  header_font_family VARCHAR(255) DEFAULT '''Open Sans'', Helvetica, Arial, sans-serif',
                  header_font_weight VARCHAR(3) DEFAULT 400,
                  header_font_style VARCHAR(7) DEFAULT 'normal',
                  body_font_size INT UNSIGNED DEFAULT 11,
                  body_font_family VARCHAR(255) DEFAULT '''Open Sans'', Helvetica, Arial, sans-serif',
                  body_font_weight VARCHAR(3) DEFAULT 400,
                  body_font_style VARCHAR(7) DEFAULT  'normal',
                  caption_show_caption TINYINT(1) UNSIGNED DEFAULT 1,
                  caption_caption_side TINYINT(1) UNSIGNED DEFAULT 1,
                  caption_text_align TINYINT(1) UNSIGNED DEFAULT 1,
                  caption_font_size SMALLINT UNSIGNED DEFAULT 11,
                  caption_font_family VARCHAR(255) DEFAULT '''Open Sans'', Helvetica, Arial, sans-serif',
                  caption_font_weight VARCHAR(3) DEFAULT '400',
                  caption_font_style VARCHAR(7) DEFAULT 'normal',
                  caption_font_color VARCHAR(7) DEFAULT '#666666',
                  autocolors_priority VARCHAR(7) DEFAULT 'rows',
                  autocolors_affected_rows_1 VARCHAR(2000) DEFAULT '',
                  autocolors_rows_background_color_1 VARCHAR(7) DEFAULT '#FFFFFF',
                  autocolors_rows_font_color_1 VARCHAR(7) DEFAULT '#666666',
                  autocolors_affected_rows_2 VARCHAR(2000) DEFAULT '',
                  autocolors_rows_background_color_2 VARCHAR(7) DEFAULT '#FFFFFF',
                  autocolors_rows_font_color_2 VARCHAR(7) DEFAULT '#666666',
                  autocolors_affected_rows_3 VARCHAR(2000) DEFAULT '',
                  autocolors_rows_background_color_3 VARCHAR(7) DEFAULT '#FFFFFF',
                  autocolors_rows_font_color_3 VARCHAR(7) DEFAULT '#666666',
                  autocolors_affected_rows_4 VARCHAR(2000) DEFAULT '',
                  autocolors_rows_background_color_4 VARCHAR(7) DEFAULT '#FFFFFF',
                  autocolors_rows_font_color_4 VARCHAR(7) DEFAULT '#666666',
                  autocolors_affected_rows_5 VARCHAR(2000) DEFAULT '',
                  autocolors_rows_background_color_5 VARCHAR(7) DEFAULT '#FFFFFF',
                  autocolors_rows_font_color_5 VARCHAR(7) DEFAULT '#666666',
                  autocolors_affected_columns_1 VARCHAR(110) DEFAULT '',
                  autocolors_columns_background_color_1 VARCHAR(7) DEFAULT '#FFFFFF',
                  autocolors_columns_font_color_1 VARCHAR(7) DEFAULT '#666666',
                  autocolors_affected_columns_2 VARCHAR(110) DEFAULT '',
                  autocolors_columns_background_color_2 VARCHAR(7) DEFAULT '#FFFFFF',
                  autocolors_columns_font_color_2 VARCHAR(7) DEFAULT '#666666',
                  autocolors_affected_columns_3 VARCHAR(110) DEFAULT '',
                  autocolors_columns_background_color_3 VARCHAR(7) DEFAULT '#FFFFFF',
                  autocolors_columns_font_color_3 VARCHAR(7) DEFAULT '#666666',
                  autocolors_affected_columns_4 VARCHAR(110) DEFAULT '',
                  autocolors_columns_background_color_4 VARCHAR(7) DEFAULT '#FFFFFF',
                  autocolors_columns_font_color_4 VARCHAR(7) DEFAULT '#666666',
                  autocolors_affected_columns_5 VARCHAR(110) DEFAULT '',
                  autocolors_columns_background_color_5 VARCHAR(7) DEFAULT '#FFFFFF',
                  autocolors_columns_font_color_5 VARCHAR(7) DEFAULT '#666666',
                  autoalignment_priority VARCHAR(7) DEFAULT 'rows',
                  autoalignment_affected_rows_left VARCHAR(2000) DEFAULT '',
                  autoalignment_affected_rows_center VARCHAR(2000) DEFAULT '',
                  autoalignment_affected_rows_right VARCHAR(2000) DEFAULT '',
                  autoalignment_affected_columns_left VARCHAR(110) DEFAULT '',
                  autoalignment_affected_columns_center VARCHAR(110) DEFAULT '',
                  autoalignment_affected_columns_right VARCHAR(110) DEFAULT '',
                  hide_tablet_list VARCHAR(110) DEFAULT '',
                  hide_phone_list VARCHAR(110) DEFAULT '',
                  phone_header_font_size INT UNSIGNED DEFAULT 11,
                  phone_body_font_size INT UNSIGNED DEFAULT 11,
                  phone_caption_font_size INT UNSIGNED DEFAULT 11,
                  phone_hide_images TINYINT(1) UNSIGNED DEFAULT 0,
                  tablet_header_font_size INT UNSIGNED DEFAULT 11,
                  tablet_body_font_size INT UNSIGNED DEFAULT 11,
                  tablet_caption_font_size INT UNSIGNED DEFAULT 11,
                  tablet_hide_images TINYINT(1) UNSIGNED DEFAULT 0,
                  enable_cell_properties TINYINT(1) UNSIGNED DEFAULT 1,
                  formula_average_decimals INT UNSIGNED,
                  formula_average_round INT UNSIGNED,
                  PRIMARY KEY (id)
            )
            COLLATE = utf8_general_ci
            ";

            dbDelta($sql);

            //create *prefix*_data
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
            $sql = "CREATE TABLE $table_name (
              id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
              table_id BIGINT UNSIGNED NOT NULL,
              row_index BIGINT UNSIGNED,
              content LONGTEXT,
              PRIMARY KEY (id)
            )
            COLLATE = utf8_general_ci
            ";

            dbDelta($sql);

            //create *prefix*_cell
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
            $sql = "CREATE TABLE $table_name (
              id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
              table_id BIGINT UNSIGNED NOT NULL,
              row_index BIGINT UNSIGNED NOT NULL,
              column_index INT UNSIGNED NOT NULL,
              html_content TEXT DEFAULT '',
              text_color VARCHAR(7) DEFAULT '',
              background_color VARCHAR(7) DEFAULT '',
              font_weight VARCHAR(3) DEFAULT '400',
              font_style VARCHAR(7) DEFAULT 'normal',
              link VARCHAR(2083) DEFAULT '',
              link_color VARCHAR(7) DEFAULT '',
              open_link_new_tab TINYINT(1) UNSIGNED DEFAULT 0,
              image_left VARCHAR(2083) DEFAULT '',
              image_left_link VARCHAR(2083) DEFAULT '',
              image_left_open_link_new_tab TINYINT(1) UNSIGNED DEFAULT 0,
              image_right VARCHAR(2083) DEFAULT '',
              image_right_link VARCHAR(2083) DEFAULT '',
              image_right_open_link_new_tab TINYINT(1) UNSIGNED DEFAULT 0,
              alignment VARCHAR(6) DEFAULT 'center',
              formula VARCHAR(7) DEFAULT 'sum',
              formula_data VARCHAR(110) DEFAULT '',
              row_slots SMALLINT UNSIGNED DEFAULT 1,
              column_slots SMALLINT UNSIGNED DEFAULT 1,
              PRIMARY KEY (id)
            )
            COLLATE = utf8_general_ci
            ";

            dbDelta($sql);

            //Import data from League Table 1_x to League Table 2_x if the database tables of the old version are available
            $this->import_from_1_x();

            //Update database version
            update_option($this->shared->get('slug') . '_database_version', "3");

        }

    }

    /*
     * plugin delete
     */
    static public function un_delete()
    {

        /*
         * delete options and tables for all the sites in the network
         */
        if (function_exists('is_multisite') and is_multisite()) {

            //get the current blog id
            global $wpdb;
            $current_blog = $wpdb->blogid;

            //create an array with all the blog ids
            $blogids = $wpdb->get_col("SELECT blog_id FROM $wpdb->blogs");

            //iterate through all the blogs
            foreach ($blogids as $blog_id) {

                //switch to the iterated blog
                switch_to_blog($blog_id);

                //create options and tables for the iterated blog
                dalt_Admin::un_delete_options();
                dalt_Admin::un_delete_database_tables();

            }

            //switch to the current blog
            switch_to_blog($current_blog);

        } else {

            /*
             * if this is not a multisite installation delete options and
             * tables only for the current blog
             */
            dalt_Admin::un_delete_options();
            dalt_Admin::un_delete_database_tables();

        }

    }

    /*
     * delete plugin options
     */
    static public function un_delete_options()
    {

	    //assign an instance of dalt_Shared
	    $shared = dalt_Shared::get_instance();

	    foreach ( $shared->get( 'options' ) as $key => $value ) {
		    delete_option( $key );
	    }

    }

    /*
     * delete plugin database tables
     */
    static public function un_delete_database_tables()
    {

        //assign an instance of dalt_Shared
        $shared = dalt_Shared::get_instance();

        global $wpdb;

        $table_name = $wpdb->prefix . $shared->get('slug') . "_table";
        $sql = "DROP TABLE $table_name";
        $wpdb->query($sql);

        $table_name = $wpdb->prefix . $shared->get('slug') . "_data";
        $sql = "DROP TABLE $table_name";
        $wpdb->query($sql);

        $table_name = $wpdb->prefix . $shared->get('slug') . "_cell";
        $sql = "DROP TABLE $table_name";
        $wpdb->query($sql);

    }

    /*
     * register the admin menu
     */
    public function me_add_admin_menu()
    {

        add_menu_page(
	        esc_html__('LT', 'dalt'),
	        esc_html__('League Table', 'dalt'),
            get_option($this->shared->get('slug') . "_tables_menu_capability"),
            $this->shared->get('slug') . '-tables',
            array($this, 'me_display_menu_tables'),
            'dashicons-list-view'
        );

        $this->screen_id_tables = add_submenu_page(
            $this->shared->get('slug') . '-tables',
	        esc_html__('LT - Tables', 'dalt'),
	        esc_html__('Tables', 'dalt'),
            get_option($this->shared->get('slug') . "_tables_menu_capability"),
            $this->shared->get('slug') . '-tables',
            array($this, 'me_display_menu_tables')
        );

        $this->screen_id_import = add_submenu_page(
            $this->shared->get('slug') . '-tables',
	        esc_html__('LT - Import', 'dalt'),
	        esc_html__('Import', 'dalt'),
            get_option($this->shared->get('slug') . "_import_menu_capability"),
            $this->shared->get('slug') . '-import',
            array($this, 'me_display_menu_import')
        );

        $this->screen_id_export = add_submenu_page(
            $this->shared->get('slug') . '-tables',
	        esc_html__('LT - Export', 'dalt'),
	        esc_html__('Export', 'dalt'),
            get_option($this->shared->get('slug') . "_export_menu_capability"),
            $this->shared->get('slug') . '-export',
            array($this, 'me_display_menu_export')
        );

	    $this->screen_id_help = add_submenu_page(
		    $this->shared->get('slug') . '-tables',
		    esc_html__('LT - Help', 'dalt'),
		    esc_html__('Help', 'dalt'),
		    'manage_options',
		    $this->shared->get('slug') . '-help',
		    array($this, 'me_display_menu_help')
	    );

        $this->screen_id_options = add_submenu_page(
            $this->shared->get('slug') . '-tables',
	        esc_html__('LT - Options', 'dalt'),
	        esc_html__('Options', 'dalt'),
            'manage_options',
            $this->shared->get('slug') . '-options',
            array($this, 'me_display_menu_options')
        );

    }

    /*
     * includes the tables view
     */
    public function me_display_menu_tables()
    {
        include_once('view/tables.php');
    }

    /*
     * includes the import view
     */
    public function me_display_menu_import()
    {
        include_once('view/import.php');
    }

    /*
     * includes the export view
     */
    public function me_display_menu_export()
    {
        include_once('view/export.php');
    }

	/*
	 * includes the help view
	 */
	public function me_display_menu_help()
	{
		include_once('view/help.php');
	}

    /*
     * includes the options view
     */
    public function me_display_menu_options()
    {
        include_once('view/options.php');
    }

    /*
     * register options
     */
    public function op_register_options()
    {

	    $this->menu_options->register_options();

    }

    /*
     * If the temporary tables are more than 100 clear the older (first inserted) temporary table.
     *
     * This method is used to avoid un unlimited number of temporary table stored in the 'table', 'data' and 'cell' db
     * tables.
     *
     * By deleting all the temporary tables (and not only the last one like this method does) wouldn't be possible to
     * work on multiple tabs on the 'Tables' menu without being unable to save the table associated with the first
     * opened tabs.
     *
     * With this method a maximum of 100 tabs can be opened on the 'Table' menu to create tables at the same time. If
     * 101 tabs are for example opened, in the first of these 101 tabs the data of the table will not be saved because
     * the temporary data are deleted.
     */
    public function delete_older_temporary_table()
    {

        //get all the temporary tables as an array
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
        $temporary_table_a = $wpdb->get_results("SELECT * FROM $table_name WHERE temporary = 1 ORDER BY id", ARRAY_A);

        //verify if the temporary tables are more than 100
        if (count($temporary_table_a) > 100) {

            //get the id of the older (first inserted) table
            $older_id = $temporary_table_a[0]['id'];

            //delete the older (first inserted) temporary table
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
            $safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE id = %d", $older_id);
            $result = $wpdb->query($safe_sql);

            //delete all the data associated with the older (first inserted) temporary table
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
            $safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE table_id = %d", $older_id);
            $result = $wpdb->query($safe_sql);

            //delete all the cells associated with the older (first inserted) temporary table
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
            $safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE table_id = %d", $older_id);
            $result = $wpdb->query($safe_sql);

        }

    }

    /*
     * Initialize the table data based on the defined table id, number of rows and number of columns
     *
     * @param $table_id Int The table id
     * @param $number_of_rows Int The number of rows
     * @param $number_of_columns Int The number of columns
     */
    public function initialize_table_data($table_id, $number_of_rows, $number_of_columns)
    {

        for ($row_index = 0; $row_index < $number_of_rows; $row_index++) {

            if ($row_index == 0) {
                $row_data = array();
                for ($i = 1; $i <= $number_of_columns; $i++) {
                    $row_data[] = 'Label ' . $i;
                }
                $row_data_json = json_encode($row_data);
                $this->shared->data_insert_record($table_id, $row_index, $row_data_json);
            } else {
                $row_data = array_fill(0, $number_of_columns, 0);
                $row_data_json = json_encode($row_data);
                $this->shared->data_insert_record($table_id, $row_index, $row_data_json);
            }

        }

    }

    /**
     * Add the proper filters used to register the TinyMCE plugin and the TinyMCE button
     */
    function create_tinymce_plugin()
    {

        //The TinyMCE plugin is created only for the users with the Tables Menu Capability
        if ( !current_user_can(get_option( $this->shared->get('slug') . "_tables_menu_capability")) )  {
            return;
        }

        if (get_user_option('rich_editing') == 'true') {

            //filter used to create the tinymce plugin
            add_filter('mce_external_plugins', array($this, 'add_tinymce_plugin'));

            //filter used to create the tinymce button
            add_filter('mce_buttons', array($this, 'register_tinymce_buttons'));

        }

    }

    //Add the 'leaguetable' TinyMCE Plugin
    public function add_tinymce_plugin($plugin_array)
    {

        $plugin_array['leaguetable'] = $this->shared->get("url") . 'admin/assets/js/tinymce-leaguetable.js';
        return $plugin_array;

    }

    /*
     * Add the "selectleaguetable" tinymce button
     *
     * @return array
     */
    public function register_tinymce_buttons($buttons)
    {

        array_push($buttons, "", "selectleaguetable");
        return $buttons;

    }

    /*
     * The click on the "Export" button available in the "Export" menu is intercepted and the
     * method that generates the downloadable XML file is called
     */
    public function export_xml_controller()
    {

        /*
         * Intercept requests that come from the "Export" button of the
         * "League Table -> Export" menu and generate the downloadable XML file
         */
        if (isset($_POST['dalt_export'])) {

            //verify capability
            if (!current_user_can(get_option($this->shared->get('slug') . "_export_menu_capability"))) {
                wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'dalt'));
            }

            //get the data from the table db
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
            $table_a = $wpdb->get_results("SELECT * FROM $table_name WHERE temporary = 0 ORDER BY id ASC", ARRAY_A);

            //if there are data generate the csv header and the content
            if (count($table_a) > 0) {

                //generate the header of the XML file
                header('Content-Encoding: UTF-8');
                header('Content-type: text/xml; charset=UTF-8');
                header("Content-Disposition: attachment; filename=league-table-" . time() . ".xml");
                header("Pragma: no-cache");
                header("Expires: 0");

                //generate initial part of the XML file
                $out = '<?xml version="1.0" encoding="UTF-8" ?>';
                $out .= '<root>';

                //set column content
                foreach ($table_a as $table) {

                    $out .= "<table>";

                    //get all the indexes of the $table array
                    $table_keys = array_keys($table);

                    //cycle through all the indexes of $table and create all the tags related to this record
                    foreach ($table_keys as $key) {

                        $out .= "<" . $key . ">" . esc_attr($table[$key]) . "</" . $key . ">";

                    }

                    //add the data associated with this table from the data db table -----------------------------------
                    $table_id = $table['id'];
                    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
                    $data_a = $wpdb->get_results("SELECT * FROM $table_name WHERE table_id = $table_id ORDER BY id ASC", ARRAY_A);

                    $out .= "<data>";

                    /*
                     * Create all the tags of the table data enclosed in the <data> tag, each single record is enclosed
                     * in the <record> tag
                     */
                    foreach ($data_a as $data) {

                        $out .= "<record>";

                        //get all the indexes of the $data array
                        $data_keys = array_keys($data);

                        foreach ($data_keys as $data_key) {

                            $out .= "<" . $data_key . ">" . esc_attr($data[$data_key]) . "</" . $data_key . ">";

                        }

                        $out .= "</record>";

                    }

                    $out .= "</data>";

                    //add the cells associated with this table from the cell db table ----------------------------------
                    $table_id = $table['id'];
                    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
                    $data_a = $wpdb->get_results("SELECT * FROM $table_name WHERE table_id = $table_id ORDER BY id ASC", ARRAY_A);

                    $out .= "<cell>";

                    /*
                     * Create all the tags of the table cell enclosed in the <cell> tag, each single record is enclosed
                     * in the <record> tag
                     */
                    foreach ($data_a as $data) {

                        $out .= "<record>";

                        //get all the indexes of the $data array
                        $data_keys = array_keys($data);

                        foreach ($data_keys as $data_key) {

                            $out .= "<" . $data_key . ">" . esc_attr($data[$data_key]) . "</" . $data_key . ">";

                        }

                        $out .= "</record>";

                    }

                    $out .= "</cell>";

                    $out .= "</table>";

                }

                //generate the final part of the XML file
                $out .= '</root>';

            } else {
                return false;
            }

            echo $out;
            die();

        }

    }

    /*
     * Import data from League Table 1_x to League Table 2_x if the database tables of the old version are available
     */
    public function import_from_1_x()
    {

        //do not import if this procedure has been already executed
        if (intval(get_option($this->shared->get('slug') . '_import_from_1_x'), 0) == 1) {
            return;
        }

        //verify if the database table exists
        global $wpdb;

        //hide SQL errors
        $wpdb->hide_errors();

        //Select 1 from table_name will return false if the table does not exist.
        $table_name = $wpdb->prefix . 'da_lt_table';
        $da_lt_table_exists = $wpdb->query("select 1 from $table_name LIMIT 1");

        //Select 1 from table_name will return false if the table does not exist.
        $table_name = $wpdb->prefix . 'da_lt_table_item';
        $da_lt_table_item_exists = $wpdb->query("select 1 from $table_name LIMIT 1");

        if ($da_lt_table_exists !== false and $da_lt_table_item_exists !== false) {

            //cycle through the tables available in da_lt_table and move them in dalt_table ----------------------------
            $table_name = $wpdb->prefix . 'da_lt_table';
            $tables_a = $wpdb->get_results("SELECT * FROM $table_name ORDER BY id ASC", ARRAY_A);
            foreach ($tables_a as $key1 => $table) {

                //save the indexes of the used columns
                $used_columns = array();
                for ($i = 1; $i <= 20; $i++) {
                    if (strlen(trim($table['label_custom_stat_' . $i])) > 0) {
                        $used_columns[] = $i;
                    }
                }

                //calculate the number of rows based on the number of records available in the da_lt_table_item table
                $table_name = $wpdb->prefix . 'da_lt_table_item';
                $safe_sql = $wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE table_id = %d", $table['id']);
                $rows = $wpdb->get_var($safe_sql);

                //import the table only if there is at least one row and at least one column is used
                if ($rows > 0 and count($used_columns) > 0) {

                    //create a new record in the dalt_table (2.00) based on the data in da_lt_table (1.x)
                    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
                    $safe_sql = $wpdb->prepare("INSERT INTO $table_name SET
                    name = %s,
                    description = %s,
                    rows = %d,
                    columns = %d,
                    show_position = %d,
                    table_margin_top = %d,
                    table_margin_bottom = %d,
                    header_background_color = %s,
                    header_font_color = %s,
                    even_rows_background_color = %s,
                    even_rows_font_color = %s,
                    odd_rows_background_color = %s,
                    odd_rows_font_color = %s,
                    header_border_color = %s,
                    rows_border_color = %s,
                    phone_breakpoint = %d,
                    tablet_breakpoint = %d,
                    position_label = %s",
                        $table['name'],
                        'Table Description',
                        $rows,
                        count($used_columns) + 1,
                        $table['show_position'],
                        $table['table_margin_top'],
                        $table['table_margin_bottom'],
                        '#' . $table['th_bg_color'],
                        '#' . $table['th_font_color'],
                        '#' . $table['even_rows_bg_color'],
                        '#' . $table['even_rows_font_color'],
                        '#' . $table['odd_rows_bg_color'],
                        '#' . $table['odd_rows_font_color'],
                        '#' . $table['th_border_color'],
                        '#' . $table['td_border_color'],
                        $table['phone_breakpoint'],
                        $table['tablet_breakpoint'],
                        $table['position_label']
                    );
                    $result = $wpdb->query($safe_sql);

                    //get the automatic id of the inserted element
                    $new_table_id = $wpdb->insert_id;

                    //add the data in the labels of da_lt_table table (1.x) as the first row of the dalt_data table (2.0)
                    $row_data = array();
                    $row_data[] = $table['subject_label'];
                    for ($i = 1; $i <= 20; $i++) {
                        //add the cell data of the used columns
                        if (in_array($i, $used_columns)) {
                            $row_data[] = stripslashes($table['label_custom_stat_' . $i]);
                        }
                    }
                    $row_data_json = json_encode($row_data);

                    //create a new record in the dalt_data (2.x) based on the data in da_lt_table_item (1.x)
                    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
                    $safe_sql = $wpdb->prepare("INSERT INTO $table_name SET
                            table_id = %d,
                            row_index = %d,
                            content = %s",
                        $new_table_id,
                        0,
                        $row_data_json
                    );
                    $result = $wpdb->query($safe_sql);

                    //cycle through all the record in da_lt_table_item (1.x) and move them in dalt_table_item (2.x) --------
                    $table_name = $wpdb->prefix . 'da_lt_table_item';
                    $safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE table_id = %d ORDER BY id ASC", $table['id']);
                    $table_items_a = $wpdb->get_results($safe_sql, ARRAY_A);

                    foreach ($table_items_a as $key2 => $table_item) {

                        //prepare the content variable
                        $row_data = array();
                        $row_data[] = stripslashes($table_item['subject']);
                        for ($i = 1; $i <= 20; $i++) {
                            //add this cell data only if it's under one of the used columns
                            if (in_array($i, $used_columns)) {
                                $row_data[] = stripslashes($table_item['custom_stat_' . $i]);
                            }
                        }
                        $row_data_json = json_encode($row_data);

                        //create a new record in the dalt_data (2.x) based on the data in da_lt_table_item (1.x)
                        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
                        $safe_sql = $wpdb->prepare("INSERT INTO $table_name SET
                            table_id = %d,
                            row_index = %d,
                            content = %s",
                            $new_table_id,
                            $key2 + 1,
                            $row_data_json
                        );
                        $result = $wpdb->query($safe_sql);

                    }

                }

            }

            update_option($this->shared->get('slug') . '_import_from_1_x', '1');

        }

    }

}